<?php
/**
 * Plugin Name: WooCommerce Product Feed Exporter
 * Plugin URI: https://example.com/woocommerce-product-feed-exporter
 * Description: Export WooCommerce products to CSV format for Google Merchant Center and Bing Ads integration
 * Version: 1.0.0
 * Author: Your Name
 * Author URI: https://example.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: wc-product-feed-exporter
 * Domain Path: /languages
 * Requires at least: 5.0
 * Tested up to: 6.3
 * Requires PHP: 7.4
 * WC requires at least: 5.0
 * WC tested up to: 8.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('WC_PRODUCT_FEED_EXPORTER_VERSION', '1.0.0');
define('WC_PRODUCT_FEED_EXPORTER_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('WC_PRODUCT_FEED_EXPORTER_PLUGIN_URL', plugin_dir_url(__FILE__));
define('WC_PRODUCT_FEED_EXPORTER_PLUGIN_BASENAME', plugin_basename(__FILE__));

/**
 * Main plugin class
 */
class WC_Product_Feed_Exporter {
    
    /**
     * Single instance of the class
     */
    private static $instance = null;
    
    /**
     * Get single instance
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Constructor
     */
    private function __construct() {
        add_action('plugins_loaded', array($this, 'init'));
        register_activation_hook(__FILE__, array($this, 'activate'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
    }
    
    /**
     * Initialize the plugin
     */
    public function init() {
        // Check if WooCommerce is active
        if (!class_exists('WooCommerce')) {
            add_action('admin_notices', array($this, 'woocommerce_missing_notice'));
            return;
        }
        
        // Load required files
        $this->load_dependencies();
        
        // Initialize admin
        if (is_admin()) {
            new WC_Product_Feed_Admin();
        }
    }
    
    /**
     * Load plugin dependencies
     */
    private function load_dependencies() {
        require_once WC_PRODUCT_FEED_EXPORTER_PLUGIN_DIR . 'includes/class-product-feed-admin.php';
        require_once WC_PRODUCT_FEED_EXPORTER_PLUGIN_DIR . 'includes/class-csv-exporter.php';
    }
    
    /**
     * Plugin activation hook
     */
    public function activate() {
        // Check WordPress version
        if (version_compare(get_bloginfo('version'), '5.0', '<')) {
            wp_die(__('This plugin requires WordPress version 5.0 or higher.', 'wc-product-feed-exporter'));
        }
        
        // Check PHP version
        if (version_compare(PHP_VERSION, '7.4', '<')) {
            wp_die(__('This plugin requires PHP version 7.4 or higher.', 'wc-product-feed-exporter'));
        }
        
        // Check if WooCommerce is active
        if (!class_exists('WooCommerce')) {
            wp_die(__('This plugin requires WooCommerce to be installed and activated.', 'wc-product-feed-exporter'));
        }
    }
    
    /**
     * Plugin deactivation hook
     */
    public function deactivate() {
        // Clean up any temporary files or data if needed
    }
    
    /**
     * Show notice if WooCommerce is not active
     */
    public function woocommerce_missing_notice() {
        echo '<div class="notice notice-error"><p>';
        echo __('WooCommerce Product Feed Exporter requires WooCommerce to be installed and activated.', 'wc-product-feed-exporter');
        echo '</p></div>';
    }
}

// Initialize the plugin
WC_Product_Feed_Exporter::get_instance();
