<?php
/**
 * Admin page template for WooCommerce Product Feed Exporter
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get product count
$product_count = wp_count_posts('product');
$published_products = $product_count->publish ?? 0;
?>

<div class="wrap wc-product-feed-exporter">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="wc-pfe-container">
        <div class="wc-pfe-header">
            <h2><?php _e('Export WooCommerce Products', 'wc-product-feed-exporter'); ?></h2>
            <p><?php _e('Export your WooCommerce products to a CSV file compatible with Google Merchant Center and Bing Ads.', 'wc-product-feed-exporter'); ?></p>
        </div>
        
        <div class="wc-pfe-stats">
            <div class="wc-pfe-stat-item">
                <span class="wc-pfe-stat-number"><?php echo esc_html($published_products); ?></span>
                <span class="wc-pfe-stat-label"><?php _e('Published Products', 'wc-product-feed-exporter'); ?></span>
            </div>
        </div>
        
        <div class="wc-pfe-export-section">
            <h3><?php _e('Export Options', 'wc-product-feed-exporter'); ?></h3>
            
            <div class="wc-pfe-field-info">
                <h4><?php _e('CSV Columns:', 'wc-product-feed-exporter'); ?></h4>
                <ul class="wc-pfe-field-list">
                    <li><?php _e('id - Product ID', 'wc-product-feed-exporter'); ?></li>
                    <li><?php _e('title - Product Title', 'wc-product-feed-exporter'); ?></li>
                    <li><?php _e('description - Product Description', 'wc-product-feed-exporter'); ?></li>
                    <li><?php _e('link - Product URL', 'wc-product-feed-exporter'); ?></li>
                    <li><?php _e('image_link - Product Image URL', 'wc-product-feed-exporter'); ?></li>
                    <li><?php _e('price - Product Price with Currency', 'wc-product-feed-exporter'); ?></li>
                </ul>
            </div>
            
            <div class="wc-pfe-export-controls">
                <button type="button" id="wc-pfe-export-btn" class="button button-primary button-large">
                    <span class="dashicons dashicons-download"></span>
                    <?php _e('Export Products to CSV', 'wc-product-feed-exporter'); ?>
                </button>
                
                <div id="wc-pfe-export-status" class="wc-pfe-status" style="display: none;">
                    <span class="dashicons dashicons-update-alt"></span>
                    <span class="wc-pfe-status-text"><?php _e('Exporting products...', 'wc-product-feed-exporter'); ?></span>
                </div>
                
                <div id="wc-pfe-export-success" class="wc-pfe-success" style="display: none;">
                    <span class="dashicons dashicons-yes-alt"></span>
                    <span class="wc-pfe-success-text"><?php _e('Export completed successfully!', 'wc-product-feed-exporter'); ?></span>
                    <a href="#" id="wc-pfe-download-link" class="button button-secondary" style="margin-left: 10px;">
                        <?php _e('Download CSV File', 'wc-product-feed-exporter'); ?>
                    </a>
                </div>
                
                <div id="wc-pfe-export-error" class="wc-pfe-error" style="display: none;">
                    <span class="dashicons dashicons-warning"></span>
                    <span class="wc-pfe-error-text"></span>
                </div>
            </div>
        </div>
        
        <div class="wc-pfe-instructions">
            <h3><?php _e('Instructions', 'wc-product-feed-exporter'); ?></h3>
            <ol>
                <li><?php _e('Click the "Export Products to CSV" button to generate your product feed.', 'wc-product-feed-exporter'); ?></li>
                <li><?php _e('Once the export is complete, click "Download CSV File" to save the file to your computer.', 'wc-product-feed-exporter'); ?></li>
                <li><?php _e('Upload the CSV file to your Google Merchant Center or Bing Ads account.', 'wc-product-feed-exporter'); ?></li>
                <li><?php _e('Review and configure additional settings in your merchant center as needed.', 'wc-product-feed-exporter'); ?></li>
            </ol>
            
            <div class="wc-pfe-note">
                <p><strong><?php _e('Note:', 'wc-product-feed-exporter'); ?></strong> 
                <?php _e('The exported CSV contains the 6 essential columns: id, title, description, link, image_link, and price. Manual export only - no automatic updates.', 'wc-product-feed-exporter'); ?></p>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    $('#wc-pfe-export-btn').on('click', function() {
        var $btn = $(this);
        var $status = $('#wc-pfe-export-status');
        var $success = $('#wc-pfe-export-success');
        var $error = $('#wc-pfe-export-error');
        
        // Reset states
        $success.hide();
        $error.hide();
        $status.show();
        $btn.prop('disabled', true);
        
        // Make AJAX request
        $.post(wcProductFeedExporter.ajax_url, {
            action: 'export_product_feed',
            nonce: wcProductFeedExporter.nonce
        })
        .done(function(response) {
            $status.hide();
            
            if (response.success) {
                $('#wc-pfe-download-link').attr('href', response.data.download_url);
                $success.show();
            } else {
                $error.find('.wc-pfe-error-text').text(response.data || 'Unknown error occurred');
                $error.show();
            }
        })
        .fail(function() {
            $status.hide();
            $error.find('.wc-pfe-error-text').text('Network error occurred');
            $error.show();
        })
        .always(function() {
            $btn.prop('disabled', false);
        });
    });
});
</script>
